/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-----------------------------------------------------------------
  Include file for binary format conversion functions.

  Development History:
    Begun: XX/XX/XX - Todd King
    Modified: 8/24/93 - Kirk Ketefian
    Edited:  04/15/94 - Gilbert Hyatt
	added function prototypes.
    Modified: 5/26/94 - Kirk : added MSDOS support

  Version:
       @(#)BC.h	1.9      (UCLA/IGPP)     28 Jul 1994
-----------------------------------------------------------------*/
#ifndef bc_h
#define bc_h 1

#include <stdio.h>      /* For NULL */
 
#define BCSuccess	1
#define BCFailure	0

static enum { BCFormatNULL = 0, BCFormatSun, BCFormatHP1000, 
              BCFormatIBM370, BCFormatMSB, BCFormatPC, BCFormatVAX
            };
static char *BCFormatList[] = { "NULL", "SUN", "HP1000",
                                "IBM370", "MSB", "PC", "VAX",
                                NULL
                              };

typedef  unsigned int BCBinary; 

typedef union {
   struct {
#if defined(vax) || defined(MSDOS)
      BCBinary mantissa0 : 16;
      BCBinary mantissa1 : 7;
      BCBinary exponent : 8;
      BCBinary sign : 1;
#else
      BCBinary sign : 1;
      BCBinary exponent : 8;
      BCBinary mantissa1 : 7;
      BCBinary mantissa0 : 16;
#endif
   } field;
   float val;
} BCIEEEFloat;

typedef union {
   struct {
#if defined(vax) || defined(MSDOS)
      BCBinary mantissa0 : 16;
      BCBinary mantissa1 : 16;
      BCBinary mantissa2 : 16;
      BCBinary mantissa3 :  4;
      BCBinary exponent  : 11;
      BCBinary sign      :  1;
#else
      BCBinary sign : 1;
      BCBinary exponent : 11;
      BCBinary mantissa3 : 4;
      BCBinary mantissa2 : 16;
      BCBinary mantissa1 : 16;
      BCBinary mantissa0 : 16;
#endif
   } field;
   double val;
} BCIEEEDouble;

/* Function pointers */

void (*BCFloatToIEEE)();
void (*BCIEEEToFloat)();

void (*BCDoubleToIEEE)();
void (*BCIEEEToDouble)();

void (*BCGFloatToIEEE)();
void (*BCIEEEToGFloat)();

void (*BCShortToIEEE)();
void (*BCIEEEToShort)();

void (*BCIntegerToIEEE)();
void (*BCIEEEToInteger)();

void (*BCLongIntegerToIEEE)();
void (*BCIEEEToLongInteger)();

void (*BCCharToASCII)();
void (*BCASCIIToChar)();

void (*BCReverseByteOrder)();

/* Prototypes for functions */

/* bits.c */
BCBinary BCMakeMask (unsigned int location, unsigned int numbits);
BCBinary BCCompliment (BCBinary bitfield, unsigned int numbits);
BCBinary BCExtractBits (BCBinary data, unsigned int location, unsigned int numbits);
BCBinary BCSetBits (BCBinary data, unsigned int location, unsigned int numbits, BCBinary value);
/* binary.c */
int BCSetFormat (int token);
int BCFormatToken (char format[]);
/* swap.c */
void BCSwapBytes (char *ptr, int len);
void BCSwap2BWord (char *ptr, int len);
void BCSwap4BWord (char *ptr, int len);
void BCGenericReverseByteOrder (char *ptr, int len);
/* ieee.c */
int BCSetIEEEFloatNaN (BCIEEEFloat *f);
int BCIsIEEEFloatNaN (BCIEEEFloat *f);
int BCDumpIEEEFloat (BCIEEEFloat *f);
int BCSetIEEEDoubleNaN (BCIEEEDouble *f);
int BCIsIEEEDoubleNaN (BCIEEEDouble *f);
int BCDumpIEEEDouble (BCIEEEDouble *f);
/* generic.c */
void BCDoNothing (void);
/* null.c */
int BCNullFormat (void);
/* vax.c */
void VAXFloatToIEEE (float *val);
void VAXIEEEToFloat (float *val);
void VAXDoubleToIEEE (double *val);
void VAXIEEEToDouble (double *val);
void VAXGFloatToIEEE (double *val);
void VAXIEEEToGFloat (double *val);
void VAXShortToIEEE (short *val);
void VAXIEEEToShort (short *val);
void VAXIntegerToIEEE (int *val);
void VAXIEEEToInteger (int *val);
void VAXLongIntegerToIEEE (long int *val);
void VAXIEEEToLongInteger (long int *val);
void BCVAXFormat (void);
/* sun.c */
int BCSunFormat (void);
/* pc.c */
void PCFloatToIEEE (float *val);
void PCIEEEToFloat (float *val);
void PCDoubleToIEEE (double *val);
void PCIEEEToDouble (double *val);
void PCShortToIEEE (short *val);
void PCIEEEToShort (short *val);
void PCIntegerToIEEE (int *val);
void PCIEEEToInteger (int *val);
void PCLongIntegerToIEEE (long int *val);
void PCIEEEToLongInteger (long int *val);
void BCPCFormat (void);
/* msb.c */
void MSBFloatToIEEE (float *val);
void MSBIEEEToFloat (float *val);
void MSBDoubleToIEEE (double *val);
void MSBIEEEToDouble (double *val);
void MSBShortToIEEE (short *val);
void MSBIEEEToShort (short *val);
void MSBIntegerToIEEE (int *val);
void MSBIEEEToInteger (int *val);
void MSBLongIntegerToIEEE (long int *val);
void MSBIEEEToLongInteger (long int *val);
void BCMSBFormat (void);
/* ibm370.c */
void IBM370FloatToIEEE (int *ibm);
void IBM370IEEEToFloat (int *ieee);
void IBM370DoubleToIEEE (int ibm[]);
void IBM370IEEEToDouble (int ieee[]);
void IBM370ASCIIToChar (unsigned char buffer[], int len);
void IBM370CharToASCII (unsigned char buffer[], int len);
void BCIBM370Format (void);
/* hp1000.c */
void HP1000FloatToIEEE (float *val);
void HP1000IEEEToFloat (float *val);
void HP1000DoubleToIEEE (double *val);
void HP1000IEEEToDouble (double *val);
void BCHP1000Format (void);

#endif /* bc_h */
