/*---------------------------------------------------------------*/
/*   Copyright (c) 1994 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*------------------------------------------------------------
   Declarations for the parserc library.

   Development History:
      Begun: 04/18/94 - Todd King
      Edited:04/20/94 - Gilbert Hyatt
	added in function prototypes.

   Version:
      @(#)parserc.h	1.4   (UCLA/IGPP)   28 Jul 1994
--------------------------------------------------------------*/
#ifndef _PARSERC_
#define _PARSERC_

#include "pattern.h"

/* function prototypes */

/* AbbrevPush.c */
AbbrevNode *AbbrevPushNode (AbbrevNode *abbrevList, char abbrev[], char trans[]);
/* AbbrevTrans.c */
char *AbbrevTrans (AbbrevNode *abbrevList, char abbrev[]);
/* cleanparse.c */
int cleanparse (char string[], char *part[], char delim[], int maxpart);
/* clipspc.c */
int clipspc (char instr[]);
/* colparse.c */
int colparse (char colstring[], char *colarray[], int maxarray, int duplicates_allowed);
/* dojustify.c */
int dojustify (char string[], int margin, int width);
/* findrep.c */
int findrep (char in[], char find[], char rep[]);
/* findrep2.c */
int findrep2 (char in[], char find[], char rep[]);
/* findstr.c */
int findstr (char substr[], char in[], int xtertog);
/* getword.c */
int getword (FILE *f_ptr, char n_word[], char delim[], int w_len);
/* glob.c */
char **glob (char *s);
/* ismatch.c */
int ismatch (char *string, char *pattern);
/* KeywordMatch.c */
int KeywordMatch (char word[], char *possible[]);
/* KeywordParse.c */
int KeywordParse (char string[], char *possible[], char value[]);
/* kwmatch.c */
int kw_match (char word[], char *possible[]);
/* mop.c */
int mop (char *line, char *mask, char *part[]);
/* mop2.c */
int mop2 (char *line, char *mask, char *part[]);
/* nextword.c */
int nextword (char string[], char word[], char delim[]);
/* nstrcpy.c */
char *nstrcpy (char *dest, char *source, int nchars);
/* nstrcat.c */
char *nstrcat (char *dest, char *source, int nchars);
/* packlist.c */
int packlist (char *part[], int npart);
/* pad_str.c */
int pad_str (char str[], int n);
/* parse.c */
int parse (char string[], char *ptr_array[], char delim[], int max);
/* pattern_comp.c */
int pattern_compare (char string[], char pattern[], int single, int multiple, int escape);
/* pattern_dump.c */
void pattern_dump (PATTERN *pattern);
/* pattern_free.c */
void pattern_free (PATTERN *pattern);
/* pattern_fixed.c */
PATTERN *pattern_fixed (char string[]);
/* pattern_make.c */
PATTERN *pattern_make (void);
/* pattern_match.c */
int pattern_match (char string[], PATTERN *pattern);
/* pattern_parse.c */
PATTERN *pattern_parse (char pattern[], int single, int mulitple, int escape);
/* rcomfile.c */
int rcomfile (FILE *comfile, char cmdstr[], char delim[], char prefix[], unsigned int chk_prefix, unsigned int recl);
/* scasedown.c */
int scasedown (char string[]);
/* scaseup.c */
int scaseup (char string[]);
/* setstr.c */
char *setstr (char str[]);
/* strip_comment.c */
int strip_comment (char line[], char comment_str[], int beginning_of_line);
/* stripnl.c */
int stripnl (char str[]);
/* trimspc.c */
int trimspc (char string[]);
/* truncate_str.c */
int truncate_str (char str[], int n);
/* unescape.c */
int unescape (char str[], int ch);
/* unquote.c */
int unquote (char string[]);
/* unquote2.c */
int unquote2 (char *s);
/* WordWrap.c */
char *WordWrap (char *string, int width);

#endif /* _PARSERC_ */
