/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-----------------------------------------------------------------
  Binary conversion functions for an Intel based PC using
  IEEE floating point storage.
  An Intel based PC stores all numeric values in LSB first format.

  Development History:
    Begun: 03/20/92 - Todd King

  Version:
      %W%     (UCLA/IGPP)    %G%
-----------------------------------------------------------------*/
#include "BC.h"

/*---------------------------------------------------------
  Once the byte order of a PC single precision floating 
  point is converted to MSB it is in IEEE format.
  
  Range of Values:

     2.9**-38 to 17.0**38.

  Precision:

     one part in 2**23.

-----------------------------------------------------------*/
void 
PCFloatToIEEE (float *val)
{
   BCReverseByteOrder(val, sizeof(float));
   return;
}

void 
PCIEEEToFloat (float *val)
{
   BCReverseByteOrder(val, sizeof(float));
   return;
}

/*---------------------------------------------------------
  Once the byte order of a PC Double precision floating 
  point is converted to MSB it is IEEE format.

  Range of Values:

     2.9**-38 to 17.0**38.

  Precision:

     one part in 2**55.

-----------------------------------------------------------*/
void 
PCDoubleToIEEE (double *val)
{
   BCReverseByteOrder(val, sizeof(double));
   return;
}

void 
PCIEEEToDouble (double *val)
{
   BCReverseByteOrder(val, sizeof(double));
   return;
}

void 
PCShortToIEEE (short *val)
{
   BCReverseByteOrder(val, sizeof(short));
}

void 
PCIEEEToShort (short *val)
{
   BCReverseByteOrder(val, sizeof(short));
}

void 
PCIntegerToIEEE (int *val)
{
   BCReverseByteOrder(val, sizeof(int));
}

void 
PCIEEEToInteger (int *val)
{
   BCReverseByteOrder(val, sizeof(int));
}

void 
PCLongIntegerToIEEE (long int *val)
{
   BCReverseByteOrder(val, sizeof(long int));
}

void 
PCIEEEToLongInteger (long int *val)
{
   BCReverseByteOrder(val, sizeof(long int));
}

void 
BCPCFormat (void)
{
   BCFloatToIEEE = PCFloatToIEEE;
   BCIEEEToFloat = PCIEEEToFloat;

   BCDoubleToIEEE = PCDoubleToIEEE;
   BCIEEEToDouble = PCIEEEToDouble;

   BCGFloatToIEEE = BCDoNothing;
   BCIEEEToGFloat = BCDoNothing;

   BCShortToIEEE = PCShortToIEEE;
   BCIEEEToShort = PCIEEEToShort;

   BCIntegerToIEEE = PCIntegerToIEEE;
   BCIEEEToInteger = PCIEEEToInteger;

   BCLongIntegerToIEEE = PCLongIntegerToIEEE;
   BCIEEEToLongInteger = PCIEEEToLongInteger;

   BCCharToASCII = BCDoNothing;
   BCASCIIToChar = BCDoNothing;

   BCReverseByteOrder = BCGenericReverseByteOrder;
}
