/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffbind -------------------------------------------------------
  Binds a variable to a field in the given flatfile. Once a variable
  is bound each time the function ffread_rec() is called the value
  in the bound variable is changed to reflect the contents of the
  current record. Each time the function ffwrite_rec() is called the
  contents of the bound variable are reflected in the record before
  the record is written.

  Entry Requirements:
    ffptr: A pointer to a flatfile.
    idx: The index of the column to bind to.
    var_addr: The address of the varaible to bind to.
    type: The declared type of the variable.
    size: The declared size of the type, i.e. the dimension
	  of the variable.

  Return Value:
   FF_FAILURE if the field index, the flatfile pointer, or
	      the type is invalid
   FF_SUCCESS otherwise.

  Development History:
    Begun: 11/13/89 - Todd King
-----------------------------------------------------------------*/
#include "ffio.h"

int 
ffbind (FLATFILE *ffptr, unsigned int idx, char *var_addr, unsigned type, unsigned size)
{
  FF_BINDER *ptr;
  unsigned need;

  if(ffptr == NULL) return(FF_FAILURE);

  if(idx >= ffptr->ncols) return(FF_FAILURE);

  if(ffcheck_type(type) == FF_FAILURE) return(FF_FAILURE);

  if(ffptr->bindcnt == ffptr->bindmax) {  /* At capacity, increase size */
    need = ffptr->bindmax + FF_BIND_INC;
    if((ptr = (FF_BINDER *)malloc(sizeof(FF_BINDER) * need)) == NULL) {
      return(FF_FAILURE);
    }
    if(ffptr->bindlist != NULL) {
      memcpy((char *)ptr, (char *)ffptr->bindlist, 
	       sizeof(FF_BINDER) * ffptr->bindcnt);
    }
    free(ffptr->bindlist);
    ffptr->bindlist = ptr;
    ffptr->bindmax += FF_BIND_INC;
  }
  ffptr->bindlist[ffptr->bindcnt].vaddr = var_addr;
  ffptr->bindlist[ffptr->bindcnt].cidx = idx;
  ffptr->bindlist[ffptr->bindcnt].type = type;
  ffptr->bindlist[ffptr->bindcnt].size = size;
  ffptr->bindcnt++;

  return(FF_SUCCESS);
}

