/*-- ffbind_dfs_col ----------------------------------------------------
  Establishes a binding between a data flow column and the Flatfile.
  The binding is done to the working record of the data flow system
  which has the global name of "Rbuffer".

  Entry requirements:
     ffptr : A pointer to the flatfile for which a bind is requested.
     ff_idx : The index of the flatfile column to bind to the
              data flow column.
     df_sname : The short column name of the data flow column to
                bind to.

  Return Values:
     0 : If the bind could not be accomplished. The reasons for which
         this can occur is if the data flow column does not exist or the bind
         failed.
     1 : If all went well.

  Development History:
     Begun: 2/23/91 - Todd King
------------------------------------------------------------------------*/
#include "ffio.h"
#include "stddescc.h"	/* For definitions of DESC type */
#include <stdio.h>

extern char *Rbuffer;
extern DESC Desc[];
 
int 
ffbind_dfs_col (FLATFILE *ffptr, unsigned int ff_idx, char df_sname[])
{
   extern DESC Desc[];

   int itmp;

   itmp = colnum(df_sname);
   if(itmp == -1) return(0);    /* Unknown column */
   itmp--;

   if(ffbind(ffptr, ff_idx, (Rbuffer + Desc[itmp].start), 
       Desc[itmp].type, Desc[itmp].width) == FF_FAILURE) {
       return(0);
   }
   return(1);
}


