/*---------------------------------------------------------------*/
/*   Copyright (c) 1991 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)ffcol_lname.c	1.1   (UCLA/IGPP)   12/12/91
*/
/*-- ffcol_lname.c -------------------------------------------------------
  Returns the data type for the given field. 

  Entry Requirements:
    ffptr: A pointer to a flatfile.
    idx: The index of the column to bind to.

  Return Value:
   NULL: If the field index or the flatfile pointer is incorrect.
   otherwise: the longname of the field is returned.

  Development History:
    Begun: 09-22-92 - Gilbert Hyatt.
-----------------------------------------------------------------*/
#include "ffio.h"
#include <string.h>

char *
ffcol_lname (FLATFILE *ffptr, unsigned int idx)
{
   FF_FULL_DESC *dptr;

   if(ffptr == NULL) return(NULL);

   dptr = ffget_desc(ffptr, idx);
   if(dptr == NULL) return(NULL);

   return(strdup(dptr->longname));
}  /* end of ffcol_lname() */
