/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffcompare -------------------------------------------------
  Compares two FLATFILE pointers to see if they are the same 
  structor. The same structor meaning the same number of columns, 
  the same column names, the same column type, and width.  Their
  long names, abstact, and actual data can differ.

   Entry Requirements:
    ffptr1:    A flat file pointer (as returned from ffopen() )
    ffptr2:    A flat file pointer (as returned from ffopen() )
    checksort: If TRUE compare the sort fields match. If FALSE don't
               compare the columns sort field.

  Return Value:
     FF_SUCCESS: If same. 
     FF_FAILURE: If different. 

  Development History:
    Begun: 09/15/93 - Gilbert Hyatt
-------------------------------------------------------------*/
#include "ffio.h"
#include <memory.h>
#include <string.h>

int 
ffcompare (FLATFILE *ffptr1, FLATFILE *ffptr2, int checksort)
{
  int          index,    good;
  FF_FULL_DESC *ffdesc1, *ffdesc2;
  
  if(ffptr1 == NULL)                   return(FF_FAILURE);
  if(ffptr2 == NULL)                   return(FF_FAILURE);
  if(ffptr1->ncols  != ffptr2->ncols)  return(FF_FAILURE);
  if(ffptr1->reclen != ffptr2->reclen) return(FF_FAILURE);

  good = TRUE;
  for(index =0; index < ffptr1->ncols; index++) {
    ffdesc1 = ffget_desc(ffptr1, index);
    ffdesc2 = ffget_desc(ffptr2, index);
    if(strcmp(ffdesc1->shortname, ffdesc2->shortname) !=0) good = FALSE;
    if(ffdesc1->type  != ffdesc2->type)                    good = FALSE;
    if(ffdesc1->width != ffdesc2->width)                   good = FALSE;
    if(checksort) {
      if(ffdesc1->sort != ffdesc2->sort)                   good = FALSE;
    }
  }

  if(good == TRUE) return(FF_SUCCESS);
  else             return(FF_FAILURE);
}




