/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%    (UCLA/IGPP)    %G%
*/
/*-- ffinsert_rec ------------------------------------------
  Indentifies the current record as a new record and stores
  the record in a special location to be inserted at the current
  position within the flatfile upon a call to ffupdate().
  Insertions are always before the current record.
  Actual insertions occur when an ffupdate() is called.

  Entry Requirements:
     ffptr: A pointer to a flatfile (as returned from ffopen()).

  Return Value:
      FF_SUCCESS is the deletion was successful. FF_FAILURE if]
      the flatfile was opened for read or append or if ffptr is NULL.

  Development History:
     Begun: 1/14/92 - Todd King
-------------------------------------------------------------*/
#include <sys/types.h>
#include "ffio.h"

int 
ffinsert_rec (FLATFILE *ffptr)
{
   unsigned long need;
   char *cptr;
   FF_RECORD *rptr;

   if(ffptr == NULL) return(NULL);

   if(ffptr->open_style != FF_OPEN_UPDATE) return(FF_FAILURE);

   if(ffptr->dlist.cnt != 0) return(FF_FAILURE); /* can't intermix */

   if((ffptr->ilist.cnt  + 1) >= ffptr->ilist.max) {
      need = FF_INSERT_INC * 
	    (ffptr->ilist.cnt + FF_INSERT_INC) / FF_INSERT_INC;
      rptr = (FF_RECORD *)malloc(sizeof(FF_RECORD) * need);
      if(rptr == NULL) return(FF_FAILURE);
      ffptr->ilist.max = need;
      memcpy(rptr, ffptr->ilist.record,  
	    ffptr->ilist.cnt * sizeof(FF_RECORD));
      if(ffptr->ilist.record != NULL) free(ffptr->ilist.record);
      ffptr->ilist.record = rptr;
   }

   ffptr->ilist.record[ffptr->ilist.cnt].recnum = ffptr->cur_recnum - 1;
   cptr = (char *)malloc(ffptr->reclen);
   if(cptr == NULL) return(FF_FAILURE);
   ffptr->ilist.record[ffptr->ilist.cnt].data = cptr;
   memcpy(ffptr->ilist.record[ffptr->ilist.cnt].data, ffptr->rec_buff,
         ffptr->reclen);

   ffptr->ilist.cnt++;

   return(FF_SUCCESS);
}

