/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
 */
/*-- MATCHFILE ----------------------------------------------------*/
/* Searches for the next matching file according to the mask       */
/* previously set with 'setmask'. The search and what is returned  */
/* is controlled by the flags passed when called.                  */
/*                                                                 */
/* Returns:                                                        */
/*   -3: Non-existant directory path                               */
/*   -2: more than one file exists when 'UNIQUE' was specified     */
/*   -1: No more files.                                            */
/*    0: all's well - request completed successfully               */
/*                                                                 */
/*  Entry Requirements:                                            */
/*    filename: variable to contain the name of the file that      */
/*              matches the surrent mask.                          */
/*    flag: a composite flag composed of the values:               */
/*           D_UNIQUE: Search for a unique match                   */
/*           D_LONG: Return the long form of the match (dir+file)  */
/*           D_SHORT: Return the short form of the match (file)    */
/*                    This is the default is no flags are set      */
/*                                                                 */
/*  Developement History:                                          */
/*    Begun: 02/24/87 - Todd King                                  */
/*                   Under GG44 support                            */
/*    Edited: 03/01/94 - Gilbert Hyatt                             */
/*-----------------------------------------------------------------*/
#include "specialc.h"
#include "lowmask.h"

int 
matchfile (char *filename, unsigned int flags)
{
  /* Error values */
  int no_dir		= -3;
  int more_than_one 	= -2;
  int no_more		= -1;
  int found_one		=  0;

  extern struct filemask Fmask;
  struct dirent *direntry;

  int ret, ret_code;
  unsigned int cont, one;
  char name[5000];

  if(Fmask.dirp ==NULL){ /* If no open directory then try to open it */
    ret = 0;
    ret = strlen(Fmask.fullmask);
    while(ret > 0 && Fmask.fullmask[ret] != '/') ret--;
    if(ret < 0) {
      strcpy(Fmask.dirpath,".");
      strcpy(Fmask.halfmask, Fmask.fullmask);
    } else {            /* Seperate parts, skipping the last '/' */
      strncpy(Fmask.dirpath, Fmask.fullmask, ret);
      strcpy(Fmask.halfmask, Fmask.fullmask+ret+1);
    }
    if((Fmask.dirp =opendir(Fmask.dirpath)) ==NULL)return(no_dir); /*Non-existant*/
  }

  /* Search for a matching entry */
  cont = TRUE;
  one  = FALSE;
  while(cont) {
    if((direntry = readdir(Fmask.dirp)) == NULL) {
      if(!one) ret_code = no_more;
      cont = FALSE;
      closedir(Fmask.dirp);		/* Free and Reset pointer */
      Fmask.dirp = NULL;
      continue;			/* Don't do anything else */
    }
    sprintf(name, "%s", direntry->d_name);
    if(match(Fmask.halfmask, direntry->d_name) == 0) {
      if(flags&D_FULL) { 		/* Append path */
	strcpy(filename, Fmask.dirpath);
	strcat(filename, "/");
	strcat(filename, direntry->d_name);
      } else strcpy(filename, direntry->d_name);	/* Just return file name */

      if(flags&D_UNIQUE) {	/* Check if another name exists - cycle again */
	if(one) {
	  ret_code = more_than_one; 
	  cont = FALSE;
	  one = FALSE;
          closedir(Fmask.dirp);		/* Free and Reset pointer */
          Fmask.dirp = NULL;
	} else { one = TRUE; ret_code = found_one; }
      } else {ret_code = found_one; cont = FALSE; }
    }
  }
  return(ret_code);
}

