/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
*/

/*--READINIT -----------------------------------------------------
 Reads initilization options file. This is read from the passed
 file name. If the file does not exists nothing is done.
 What is done is that the existantance and readablility of the
 initfile is checked, if valid, then the initfile name is
 formatted as the value in a 'OPTFILE=' string and passed to
 the command handler.

 NOTE: The arguments to the command handler are:
          argstr: A null terminated array of string pointers
                  pointing to a command string.
          sublist: The variable list which can be used by the
                   command handler.

 Returns:
   0: if all went well
  -1: if file exists, but can not be read
  -2: if file does not exist.

  Entry Requirements:
    INITFILE: The full path to the initialization file
    SUBLIST: The variable list which is passed to the command
             handler.
    CMDFUNC: The name of (pointer to ) the command handler
             function

  Developement History:
    Begun: 04/14/87 - Todd King
                   Under GG44 support
-----------------------------------------------------------------*/

#include <stdio.h>		/* For NULL definition */
#include "vars.h"
#include "filetype.h"
int 
readinit (char initfile[], VAR_STRUCT_PTR *sublist, int (*cmdfunc)())
{
  char *home_dir();

  char *argstr[3];
  char *opt_name = "OPTFILE";
  char opt_com[256];

  int no_exist	= -2;
  int no_read	= -1;
  int ok	= 0;

  argstr[0] = "";	/* Place holder - needed by 'getcmdlineopt' */
  argstr[1] = opt_com;
  argstr[2] = NULL;

  sprintf(opt_com, "%s/%s", home_dir(), initfile);
  switch(filetype(opt_com)) 
  {
    case NOACCESS:		/* inaccessable */
      return(no_exist);
      break;
    case TEXTFILE:		/* Good deal */
      break;
    case NOREAD:		/* can not read */
    case DIRFILE:		/* Directory */
    case EXECFILE:		/* machine executable */
    default:		/* Any bodies guess */
      return(no_read);
      break;
  }

  sprintf(opt_com, "%s=%s/%s", opt_name, home_dir(), initfile);
  cmdfunc(2, argstr, sublist);
  return(ok);
}
