/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
#include "timec.h"

/*-- make_arb_time_str --------------------------------------
  Creates a time string according to the format specifications
  in the passed structure. Returns a pointer to a static string
  which is re-used with each call.

  Entry Requirements
    tval: The time in seconds from the beginning of the reference year.
    tt: The list of time tokens which specify how to construct 
	the time string.

   Return Value:
     A pointer to a string which contains the formatted time value.

   Development History:
      Begun: 4/2/90 - Todd King

   Version:
       %W%    (UCLA/IGPP)   %G%
-------------------------------------------------------------*/
char *
make_arb_time_str (double tval, TIME_TOKEN *tt)
{
  static char Time_str[TIME_MAX_FORMAT_STR + 1];

  int i;
  char value[TIME_MAX_TOKENS][TIME_MAX_STR];
  char tmp_fmt[TIME_MAX_FORMAT_STR + 1];
  int year, mon, day, d_of_y;
  int hour, min, sec, msec;
  float fsec;

  year = REFYR;
  mon = -1;	/* -1 to make it possible to detect if set */
  day = -1;
  d_of_y = -1;
  hour = 0;
  min = 0;
  sec = 0;
  msec = 0;

  yrmonday(tval, &year, &mon, &day, &hour, &min, &fsec);
  d_of_y = doy(year, mon, day);

  sec = fsec;
  msec = (fsec - sec) * 1000;

  for(i = 0; i < tt->ntokens; i++) {
    switch(tt->tokens[i]) {
      case FMT_YEAR:
	sprintf(value[i], "%4d", year);
	break;
      case FMT_MONTH:
	sprintf(value[i], "%02d", mon);
	break;
      case FMT_DAY:
	sprintf(value[i], "%02d", day);
	break;
      case FMT_DOY:
	sprintf(value[i], "%03d", d_of_y);
	break;
      case FMT_HOUR:
	sprintf(value[i], "%02d", hour);
	break;
      case FMT_MIN:
	sprintf(value[i], "%02d", min);
	break;
      case FMT_SEC:
	sprintf(value[i], "%02d", sec);
	break;
      case FMT_MSEC:
	sprintf(value[i], "%03d", msec);
	break;
    }
  }

/* LOOK OUT! Hard coded references. In the following function
   each element in 'value' is explicitly named and
   so must have TIME_MAX_TOKEN entries. 
*/
  strcpy(tmp_fmt, tt->fmt_spec);
  findrep(tmp_fmt, "%d", "%s");
  sprintf(Time_str, tmp_fmt, value[0], value[1], value[2], 
    value[3], value[4], value[5], value[6], value[7],
    value[8], value[9], value[10], value[11], value[12],
    value[13], value[14]
  );

  return(Time_str);
}

