/*---------------------------------------------------------------*/ 
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

#include "timec.h"

/*-- month_num -------------------------------------------------------
  Determines the month number given the month name. Recognizable
  portions of a month name also return valid month numbers.
  Returns 0 if the name is ambiguous or unknown.

  Entry Requirements:
    mstr: The textual name of a month.

  Return Values:
    The numeric index of the month. (1 = January ... 12 = December)
    0 if the the name is invalid or ambiguous.

   Development History:
      Begun: 3/28/90 - Todd King

   Version:
       %W%    (UCLA/IGPP)   %G%
---------------------------------------------------------------------*/
int 
month_num (char mstr[])
{
   char tmpstr[TIME_MAX_STR + 1];
   int midx;

   strncpy(tmpstr, mstr, TIME_MAX_STR);
   tmpstr[TIME_MAX_STR] = '\0';
   trimspc(tmpstr);
   scaseup(tmpstr);

   midx = kw_match(tmpstr, Time_month_list);
   if(midx < 0) return(0);
   else return(midx + 1);
}

