/*---------------------------------------------------------------*/ 
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

#include "timec.h"

/*-- parse_time ---------------------------------------------------
   Parses a time string and returns a binary time for
   what it specifies. A time string has the following format:

     [paradigm(]time_spec[)]

   where paradigm is the name of any of the supported formats,
   the ( is literal and the closing parenthesis is required if
   a paradigm is specified. If no paradigm is specified DFS_STYLE
   is assumed.

   Entry Requirements:
     tstr:  string containing the time specifications.

   Return Value:
     The number of seconds from the beginning of the refernce year.

   Development History:
      Begun: 3/28/90 - Todd King

   Version:
       %W%    (UCLA/IGPP)   %G%
--------------------------------------------------------------------*/
double 
parse_time (char tstr[])
{
   double parse_time_str();

   char tmpstr[TIME_MAX_STR];
   char *parts[2];
   int paradigm;

   strncpy(tmpstr, tstr, TIME_MAX_STR);
   if(mop(tmpstr, "*(*)", parts) == 2) {
      trimspc(parts[0]);
      scaseup(parts[0]);
      paradigm = kw_match(parts[0], Time_paradigms);
      if(paradigm < 0) {	/* unknown or ambiguous */
	return(0);
      }
   } else {
     paradigm = DFS_STYLE;
     parts[1] = tstr;
   }

   return(parse_time_str(parts[1], paradigm));
}

