/*---------------------------------------------------------------*/ 
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

/*----------------------------------------------------------------
   Version:
       %W%    (UCLA/IGPP)   %G%
------------------------------------------------------------------*/
/*----------------------------------------------------------------*/
/* FORTRAN access points to the functions in this library.        */
/*----------------------------------------------------------------*/

/*----------------------------------------------------------------*/
/*  Returns the number of days in a month                         */
/*----------------------------------------------------------------*/
#ifdef VMS
int fmaxdaymon(mon, yr)
#else
int maxdaymon_(mon,yr)
#endif
int *mon;			/* Jan = 1, Feb = 2, etc */
int *yr;				/* Full year A.D., e.g., 1987 */ 
{
  int maxdaymon();

  return(maxdaymon(*mon, *yr));
}  

#ifndef VMS
/*-------------------------------------------------------------
  Modified fmod()
---------------------------------------------------------------*/
double 
fmod_ (double *x, double *y)
{
  double fmod();

  return(fmod(*x, *y));
}
#endif

/*---------------------------------------------------------------*/
/* Given the year and day of year, returns the month and day of  */
/* month.                                                        */
/*---------------------------------------------------------------*/
#ifdef VMS
int fmonthday(yr, doy, month, day)
#else
int monthday_(yr, doy, month, day)
#endif
int *yr, *doy;
int *month, *day;
{
  int monthday();

  return(monthday(*yr, *doy, month, day));
}

/*--------------------------------------------------------------*/
/*	Given year, month, and day of month, return day of year */
/*	Note: doy of Jan 1 = 1;	                                */
/*--------------------------------------------------------------*/
#ifdef VMS
int fdoy(yr, mon, day)
#else
int doy_(yr,mon,day)
#endif
int *yr, *mon, *day;
{
  int doy();

  return(doy(*yr, *mon, *day));
}

/*--------------------------------------------------------------------*/
/*	Return floating point double no. of seconds since 0000 Jan 1, */
/*      in the year REFYR                                             */
/*--------------------------------------------------------------------*/
#ifdef VMS
double fstime(yr, mon, day, hr, min, sec)
#else
double sectime_(yr, mon, day, hr, min, sec)
#endif
int *yr, *mon, *day, *hr, *min;
float *sec;
{
  double sectime();

  return(sectime(*yr, *mon, *day, *hr, *min, *sec));
}

/*-------------------------------------------------------------*/
/*	Given the year, compute no. of seconds in that year	*/
/*-------------------------------------------------------------*/
#ifdef VMS
double fsecperyr(yr)
#else
double secperyr_(yr)
#endif
int *yr;
{
  double secperyr();

  return(secperyr(*yr));
}

/*---------------------------------------------------------*/
/*  Given floating point seconds from 0000 Jan 1, REFYR, 
/*  compute and return the corresponding yr, mon, day hr,  */
/*  min, sec and msec	                                   */
/*---------------------------------------------------------*/
#ifdef VMS
int fyrmonday(sectime, yr, mon, day, hr, min, sec)
#else
int yrmonday_(sectime, yr, mon, day, hr, min, sec)
#endif
double *sectime;
int *yr, *mon, *day, *hr, *min;
float *sec;
{
  int yrmonday();

  return(yrmonday(*sectime, yr, mon, day, hr, min, sec));
}

/*-- LOCALCLINE -------------------------------------------------*/
/* Returns the local cline time.                                 */
/*---------------------------------------------------------------*/
#ifdef VMS
double flocalcline()
#else
double localcline_()
#endif
{
  double localcline_();
  
  return(localcline());
}


/*--- STRTOTIME --------------------------------------------------*/
/* Returns the cline time given an string of yr/mn/day/ hr:mn:sec */
/*----------------------------------------------------------------*/
#ifdef VMS
double fstrtotime(str, str_len)
#else
double strtotime_(str, str_len)
#endif
char *str;
int str_len;
{
  char   *malloc();
  char   *temp_str;
  double ret_val;

  temp_str = malloc(str_len + 1);
  strncpy(temp_str, str, str_len);
  temp_str[str_len] = '\0';

  ret_val = strtotime(temp_str);

  free(temp_str);

  return ret_val;
}

/*----------------------------------------------------
   Returns 1 if a valid time, 0 otherwise.
------------------------------------------------------*/
#ifdef VMS
fvalidtime(yr, mon, day, hr, min, sec)
#else
validtime_(yr, mon, day, hr, min, sec)
#endif
long int *yr, *mon, *day, *hr, *min;
float    *sec;
{
  return(validtime(*yr, *mon, *day, *hr, *min, *sec));
}

