/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-------------------------------------------------------------
   Definitions for use with the Data Flow Systems buffered
   functions.
 
   Development History:
       Begun: 08/04/92  -Gilbert Hyatt.

   Version:
      @(#)buf_list.h	1.3   (UCLA/IGPP)   29 Mar 1995
--------------------------------------------------------------------*/
 
#ifndef _buf_list_h_
#define _buf_list_h_  1
 
#include <stdio.h>      /* For NULL */
#include "specialc.h"   /* For TRUE and FALSE */

#define BufNoValue         -1
#define BufNotInUses        0
#define BufRealMem         -1
#define BUF_DATA_MAX_SPACE 6000000

#define SetColVal(a, b, c)   _SetColVal(a, b, (double)(c))

typedef struct recptr {
  int           vmrecnum;
  char          *data;
  struct recptr *next;
}  RECPTR;


typedef struct {
  int     recl;                 /* length of a record in bytes          */
  int     nbufs;                /* Current number of buffers            */
  int     nrecs;                /* Current number of records            */
  int     num_fixed;            /* Is the number of buffer fixed        */
  RECPTR  *working;             /* The Working buffer                   */
  RECPTR  *first;               /* Pointer to a record pointer          */
  RECPTR  *last;                /* Pointer to a record poniter          */
  RECPTR  *end;                 /* Pointer to the last buffer           */
  RECPTR  *current;             /* Last switched pointer                */
  int     num_current;          /* Record Number of current             */
  RECPTR  *last_request;        /* Pointer to the last requested record */
  int     num_last_req;         /* Record Number of last_request        */
  RECPTR  *lastVMrec;           /* Ptr to Last VM Record Shifted Out    */
  int     num_lastVMrec;        /* Number of Last VM Record Shifted Out */
  FILE    *vmfilename;          /* Filename of Virtual Memory File      */
  int     pagesize;             /* System Page Size                     */
  int     recs_per_page;        /* Number of Records that fix in a Page */
  char    *inpage1;             /* Pointer to in Page1                  */
  char    *inpage1_bak;         /* Backup of Pointer to in Page1        */
  char    *inpage2;             /* Pointer to In Page2                  */
  char    *inpage2_bak;         /* Backup of Poniter to in Page1        */
  char    *outpage;             /* Pointer to out Page                  */
  int     num_inpage1;          /* Page Number of In Page1              */
  int     num_inpage2;          /* Page Number of In Page2              */
  int     num_outpage;          /* Page Number of Out Page              */
  int     num_in_outpage;       /* Number of Records in Outpage         */
  int     data_space_used;      /* actual space used for ->data elements*/
} BUFFER_HEAD;


char*    GetColStr();
double   GetColVal();
RECPTR*  BufGetRecPtrOf();
double   buffgetcolval();
char*    BufMalloc();
char*    BufMapData();

#endif  /* _buf_list_h_ */

