/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)buffblkc.h	1.2    (UCLA/IGPP)    29 Mar 1995
 */
#ifndef _BUFFBLK_
#define _BUFFBLK_
/*------------------------------------------------------------
  Defines the structures for buffers and blocks.

  Development History:
     Begun: 11/4/86 - Todd King
	  Under GH06 support.
     Modified: 7/20/88 - Todd King
       Eliminated unneeded elements in structures.
	  Under GH06 support.
--------------------------------------------------------------*/

#include "maxpipec.h"	/* for BLKSIZE and MAXLENGTH */

typedef struct 
{
  char block[BLKSIZE];	/* The storage area for data */
  int guage;		/* number of bytes in 'block' */
  int full;		/* What is considered a full 'block' */
  int offset;		/* Current position in the 'block' */
} BLOCK;

typedef struct
{
  char buffer[MAXLENGTH];	/* Storage area for data */
  int length;			/* The number of bytes in 'buffer' */
} BUFFER;

#endif /* _BUFFBLK_ */
