/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*--- FFCOLPARSE ------------------------------------------------

 ENTRY REQUIREMENTS:
   FFPTR:      Pointer to a flat file.
   COLSTRING:  A string to parse into an array of column
               names.  The string is a list of patterns
               or column names.  For example: "by,by,bz",
               or "b*" or "b[xyz], e?".
   COLARRAY:   An array of character pointers to place the
               names of the matching columns in.
   MAXARRAY:   The maximum number of elements in COLARRAY.
   DUPLICATES_ALLOWED:  If it is TRUE the same column name
               will be allowed to be in the array more
               that once.

 RETURN VALUES:
   The number of columns which match any of the patterns
   or -1 for an error.

 NOTES:
   Destroys COLSTRING, but dynamically allocates making
     COLSTRING reusable.

   Uses parserc, pipec and miscc libraries.

      Development History:
      COLPARSE:    Begun:  4/24/87 - Marco Zagha
                   Under GG44 support.
      FFCOLPARSE:  Begun: 6/4/92  -  Gilbert Hyatt

  Version:
     %W%    (UCLA/IGPP)   %G%

-----------------------------------------------------------------*/
#include <stdio.h>       
#include <string.h>	/* For strdup() */
#include "stddescc.h"   
#include "maxpipec.h"
#include "pattern.h" 
#include "ffio.h"

int 
ffcolparse (FLATFILE *ffptr, char colstring[], char *colarray[], int maxarray, int duplicates_allowed)
{

  int           dnum, i, nparts, matchcount;
  int           colmatch[MAXCOLS];
  char          tempname[9];
  char          *colparts[MAXCOLS];
  FF_FULL_DESC  *ffd_node;

  /* Presets   */
  matchcount = 0;
  for (i=0; i < MAXCOLS; i++) colmatch[i] = 0;

  nparts = parse(colstring, colparts, ",", MAXCOLS);
  for (i = 0; (i < nparts) && (matchcount < maxarray); i++) {
    dnum = 0;
    for (ffd_node = ffptr->descdb; ffd_node != NULL; ffd_node = ffd_node->next) {
      dnum++;
      strcpy(tempname, ffd_node->shortname);
      trimspc(tempname);  /* because strings in database are padded   */
      if (ismatch(tempname, colparts[i]))
        if (duplicates_allowed || (colmatch[dnum] == 0)) {
          colmatch[dnum] = 1;
          colarray[matchcount] = strdup(tempname);
          if (colarray[matchcount] == NULL) return (-1);
          matchcount++;
          if (matchcount >= maxarray) break;
        }  /* end of if - if */
    }  /* end of for */
  }  /* end of for */
  return(matchcount);
}  /* end of ffcolparse() */

