/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffdo_bind ----------------------------------------------------
  Performs a bind between the bound variables and the current
  record. It performs either the read or write style binds depeneding
  on the status of the direction flag.

  Entry Requirements:
    ffptr: The flat file pointer to do the bind with.
    direction: Specifies the direction for the bind operation.
	       FF_BIND_READ: load bound variable with value from
			     flatfile record.
	       FF_BIND_WRITE: load flatfile record with value in
			     bound variable.

  Returns:
    FF_SUCCESS is the type is valid
    FF_FAILURE otherwise.

  Development History:
    Begun: 11/13/89 - Todd King
-----------------------------------------------------------------*/
#include <string.h>
#include "ffio.h"

int 
ffdo_bind (FLATFILE *ffptr, unsigned direction)
{
  unsigned long i;
  double dval;
  char *ptr;
  int j;
  FF_FULL_DESC *desc;
  char tmp_str[FF_MAX_FIELD_WIDTH + 1];

  if(ffptr == NULL) return(FF_FAILURE);

  if(ffptr->bindcnt == 0) return(FF_SUCCESS);
  if(ffptr->bindlist == NULL) return(FF_SUCCESS);

  switch(direction) {
    case FF_BIND_READ:
      for(i = 0; i < ffptr->bindcnt; i++) {
        desc = ffget_desc(ffptr, ffptr->bindlist[i].cidx);
	switch(desc->type) {
	  case FF_ALPHA:
	    ptr = ffget_col_str(ffptr, ffptr->bindlist[i].cidx);
	    strncpy(ffptr->bindlist[i].vaddr, ptr,
	       ffptr->bindlist[i].size - 1);
	    ffptr->bindlist[i].vaddr[ffptr->bindlist[i].size - 1] = '\0';
            ptr = ffptr->bindlist[i].vaddr;
            for(j = strlen(ptr) - 1; j >= 0; j--) { /* Trim trailing spaces */
                if(!isspace(ptr[j])) break;
            }
            ptr[j + 1] = '\0';
	    break;
	  default:	/* A numeric type */
	    dval = ffget_col_val(ffptr, ffptr->bindlist[i].cidx);
	    switch(ffptr->bindlist[i].type) {
	      case FF_INT:
		(* (int *) ffptr->bindlist[i].vaddr) = dval;
		break;
	      case FF_FLOAT:
		(* (float *) ffptr->bindlist[i].vaddr) = dval;
		break;
	      case FF_DOUBLE:
		(* (double *) ffptr->bindlist[i].vaddr) = dval;
		break;
	      case FF_TIME:
		(* (TIME *) ffptr->bindlist[i].vaddr) = dval;
		break;
	    }
	    break;
	}
      }
      break;
    case FF_BIND_WRITE:
      for(i = 0; i < ffptr->bindcnt; i++) {
        desc = ffget_desc(ffptr, ffptr->bindlist[i].cidx);
	switch(desc->type) {
	  case FF_ALPHA:	/* OK to copy directly */
            /* printf("desc, bind: %d, %d\n", desc->width, 
                  ffptr->bindlist[i].size);
            */
            if(desc->width <= ffptr->bindlist[i].size) {
	       ffset_col_str(ffptr, ffptr->bindlist[i].cidx, 
			ffptr->bindlist[i].vaddr);
            } else {	/* Bound variable is smaller than field */
               strncpy(tmp_str, ffptr->bindlist[i].vaddr, 
                  ffptr->bindlist[i].size);
               tmp_str[ffptr->bindlist[i].size] = '\0';
	       ffset_col_str(ffptr, ffptr->bindlist[i].cidx, 
			tmp_str);
            }
	    break;
	  default:	/* A numeric type */
	    switch(ffptr->bindlist[i].type) {
	      case FF_INT:
		dval = (* (int *) ffptr->bindlist[i].vaddr);
		break;
	      case FF_FLOAT:
		dval = (* (float *) ffptr->bindlist[i].vaddr);
		break;
	      case FF_DOUBLE:
		dval = (* (double *) ffptr->bindlist[i].vaddr);
		break;
	      case FF_TIME:
		dval = (* (TIME *) ffptr->bindlist[i].vaddr);
		break;
	    }
	    ffset_col_val(ffptr, ffptr->bindlist[i].cidx, dval);
	    break;
	}
      }
      break;
    default: 
      return(FF_FAILURE);
  }
  return(FF_SUCCESS);
}
  
