/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffget_col_str ------------------------------------------------
  Gets the contents of a field given its index in the descriptor 
  database maintained as part of the information related to
  a flatfile. The contents are returned as a string whether the field
  is a numeric or character type field. Numeric fields are formated
  with standard C formating for the particular type. An internal buffer
  called _FF_getcol_str is used to place the contents in. This buffer
  is re-used with each call to this function.

  Entry Requirements:
    ffptr: A pointer to a flatfile.
    idx: The index of the field of interest. Note that indexing
	 begins at 0.

  Return Value:
    Returns a pointer to a string which contains the contents of
    the specified field. If the field is
    unknown or ffptr is invalid then a NULL is returned.

  Development History:
    Begun: 11/13/89 - Todd King
-----------------------------------------------------------------*/
#include "ffio.h"

char *
ffget_col_str (FLATFILE *ffptr, unsigned long idx)
{
   static char _FF_getcol_str[FF_MAX_FIELD_WIDTH + 1];
   char *ptr;
   FF_FULL_DESC *desc;

   if(ffptr == NULL) return(NULL);

   if(idx >= ffptr->ncols) return(NULL);

   desc = ffget_desc(ffptr, idx);
   switch(desc->type) {
      case FF_INT:
	ptr = ffptr->rec_buff + desc->offset;
	sprintf(_FF_getcol_str, "%d", (* (int *)ptr));
	break;
      case FF_FLOAT:
	ptr = ffptr->rec_buff + desc->offset;
	sprintf(_FF_getcol_str, "%f", (* (float *)ptr));
	break;
      case FF_DOUBLE:
	ptr = ffptr->rec_buff + desc->offset;
	sprintf(_FF_getcol_str, "%lf", (* (double *)ptr));
	break;
      case FF_ALPHA:
	ptr = ffptr->rec_buff + desc->offset;
	strncpy(_FF_getcol_str, ptr, desc->width);
	_FF_getcol_str[desc->width] = '\0';
	break;
      case FF_TIME:
	ptr = ffptr->rec_buff + desc->offset;
	sprintf(_FF_getcol_str, "%lf", (* (TIME *)ptr)); /* TIME == double */
	break;
  }
  return(_FF_getcol_str);
}

