/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffget_dfs_desc ----------------------------------------------------
  Extracts the description of a column in the data flow. This
  description is reformatted to match that required by the ffio
  library calls. A pointer to a FF_DESC filled with the the descriptor
  information is return. This FF_DESC is re-used with each call to
  ffget_dfs_desc().
 
  Entry Rquirements:
     df_sname : The short name of the data flow column for which
                the descriptor information is desired.
 
  Return Values:
     NULL : If the passed short column name is invalid
     otherwise : A pointer to a FF_DESC structure filled with
                 the descriptor for the column.
 
  Development History:
      Begun: 2/24/91 - Todd King
-------------------------------------------------------------------------*/
#include "ffio.h"
#include "stddescc.h"

FF_DESC *
ffget_dfs_desc (char df_sname[])
{
   static FF_DESC Get_ff_desc;
 
   if(!exists(df_sname)) return(NULL);
 
   strncpy(Get_ff_desc.longname, lcolname(df_sname), FF_LNAME);
   Get_ff_desc.longname[FF_LNAME] = '\0';
   strncpy(Get_ff_desc.shortname, df_sname, FF_SNAME);
   Get_ff_desc.shortname[FF_LNAME] = '\0';
   strncpy(Get_ff_desc.units, colunits(df_sname), FF_UNITS);
   Get_ff_desc.units[FF_LNAME] = '\0';
   Get_ff_desc.type = coltype(df_sname);
   Get_ff_desc.width = colwidth(df_sname);
   Get_ff_desc.sort = colsort(df_sname);
 
   return(&Get_ff_desc);
}


