/*---------------------------------------------------------------*/
/*   Copyright (c) 1991 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
*/
/*-- ffmake_path -------------------------------------------------------
  Makes all necessary directories in a given file name reference.

  Entry Requirements:
    fname: The fully qualified filename including path.

  Return Value:
   0 : If unable to create the path
   1 : If the path was successfully created or already existed.

  Development History:
    Begun: 01/16/92 - Todd King
-----------------------------------------------------------------*/
#include <stdio.h>	/* For NULL */
#include <errno.h>	/* For errno and error codes */
#include <string.h>	/* for strrchr() */
int 
ffmake_path (char path[])
{
   char *ptr;
   int itmp;

   if(mkdir(path, 493) == -1) {   /* 493 = 111101101 */
      if(errno == ENOENT) {
         ptr = strrchr(path, '/');
         if(ptr == NULL) return(0);
         *ptr = '\0'; /* End path here */
         itmp  = ffmake_path(path);
         *ptr = '/';    /* Replace delimiter */
         return(itmp);
      } else {
         perror(path);
         return(0);
      }
   }
   return(1);
}

