/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffmove_to_rec -------------------------------------------------
  Sets the current record to be the one specified. Returns FF_FAILURE
  is unable to do so and FF_SUCCESS if it can. This call positions the 
  file pointer at the beginning of the record. To extract the 
  contents of the record you must make a call to ffread_rec()
  or something similar.

   Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )
    recnum: A number indicating the record number to make the current.

  Return Value:
    FF_SUCCESS: If the move was possible and successful.
    FF_FAILURE: If the flatfile pointer was invalid or the 
                move was impossible.
  
  Development History:
    Begun: 11/1/89 - Todd King
---------------------------------------------------------------------*/
#include "ffio.h"

int 
ffmove_to_rec (FLATFILE *ffptr, unsigned long recnum)
{
  if(ffptr == NULL) return(FF_FAILURE);

  if(fseek(ffptr->data, recnum * ffptr->reclen, 0) == -1) return(FF_FAILURE);
  ffptr->cur_recnum = recnum;
  return(FF_SUCCESS);
}

