/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- _ffset_col_val -----------------------------------------------
  Sets the value of a field given its index in the descriptor 
  database maintained as part of the information related to
  a flatfile. 
  NOTE: The value argument must be a double type value. This
        requires that all values passed to it be type cast as
        a double. To facilate this there is a macro (called
        ffset_col_val()) which translates into a call to this
        function with the type casting done.

  Entry Requirements:
    ffptr: A pointer to a flatfile.
    idx: The index of the field of interest. Note that indexing
	 begins at 0.
    value: The value to set the column to.

  Returns:
    FF_FAILURE if the field index or flatfile pointer is invalid.
    FF_SUCCESS otherwise

  Development History:
    Begun: 11/13/89 - Todd King
-----------------------------------------------------------------*/
#include "ffio.h"

int 
_ffset_col_val (FLATFILE *ffptr, unsigned long idx, double value)
{
   char *ptr;
   char temp_str[FF_MAX_FIELD_WIDTH + 1];
   FF_FULL_DESC *desc;

   if(ffptr == NULL) return(FF_FAILURE);

   if(idx >= ffptr->ncols) return(FF_FAILURE);

   desc = ffget_desc(ffptr, idx);

   switch(desc->type) {
      case FF_INT:
	ptr = ffptr->rec_buff + desc->offset;
	(* (int *)ptr) = (int) value;
	break;
      case FF_FLOAT:
	ptr = ffptr->rec_buff + desc->offset;
	(* (float *)ptr) = (float) value;
	break;
      case FF_DOUBLE:
	ptr = ffptr->rec_buff + desc->offset;
	(* (double *)ptr) = (double) value;
	break;
      case FF_ALPHA:
	ptr = ffptr->rec_buff + desc->offset;
	ffpad_str(temp_str, ' ', desc->width);
	strncpy(ptr, temp_str, desc->width);
	break;
      case FF_TIME:
	ptr = ffptr->rec_buff + desc->offset;
	(* (TIME *)ptr) = (TIME) value;
	break;
  }
  return(FF_SUCCESS);
}

