/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffwrite_rec ---------------------------------------------------
  Writes the record in the current record buffer out to the flatfile.
  at the current record.
  This operation also advances the record pointer one record.
  Returns FF_SUCCESS upon successful completion or FF_FAILURE
  upon error or encountering the end of file.

   Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )

  Return Value:
    FF_SUCCESS if the write was successful,
    FF_FAILURE if the the flatfile pointer is invalid or the
	write failed.
  
  Development History:
    Begun: 11/1/89 - Todd King
---------------------------------------------------------------------*/
#include "ffio.h"

int 
ffwrite_rec (FLATFILE *ffptr)
{
  if(ffptr == NULL) return(FF_FAILURE);

  ffdo_bind(ffptr, FF_BIND_WRITE);
  if(fwrite(ffptr->rec_buff, ffptr->reclen, 1, ffptr->data) == 0) {
    return(FF_FAILURE);
  }
  ffptr->cur_recnum++;
  if(ffptr->cur_recnum > ffptr->nrecs) ffptr->nrecs++;
  return(FF_SUCCESS);
}

