/*---------------------------------------------------------------*/
/*   Copyright (c) 1993 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%   (UCLA/IGPP)   %G%
 */
#include <stdio.h>
#include <sys/param.h>	/* For MAXAPTHLEN */
#include "funcdefc.h"	/* For getFittingName() */
#include "message.h"	/* For MM_BUFF_MAX */

/*-----------------------------------------------------------------
 A function which will work with the message library.
 Takes a message forwarded by a call to pmessae() and writes
 it to the data flow message log.

  Entry Requirements:
    message : The tex of the message to print.
    severity : The severity type of the message.
    exit_code : The exit code to use. 

  Developement History:
    Begun: 04/30/93 - Todd King
-----------------------------------------------------------------*/
int 
dfsMessage (char *message[], int severity, int exit_code)
{
   char buffer[MM_BUFF_MAX + MAXPATHLEN + 3];

   sprintf(buffer, "%s: %s", getFittingName(), message);
   switch(severity) { 
      case MM_FATAL:
	 plog(buffer, 'E');
	 break;
      default:
	 plog(buffer, 'I');
	 break;
   }
   return(1);
}
