/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/* -- NSTRCPY ---------------------------------------------- */
/* This function copies up to NCHARS characters of SOURCE    */
/* to DEST.  This function is almost identical to strncpy,   */
/* except that this function guarantees that the result is   */
/* null-terminated, while strncpy does not.                  */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*   DEST:   Destination String                              */
/*   SOURCE: Source String                                   */
/*   NCHARS: Maximum number of characters to copy            */
/*                                                           */
/* RETURN VALUES:                                            */
/*   Returns a pointer to the result                         */
/*                                                           */
/* Development History:                                      */
/*   Begun: 4/29/88 - Marco Zagha                            */
/*            Under GY49 Support                             */
/*                                                           */
/*  Version:                                                 */
/*     %W%      (UCLA/IGPP)     %G%                          */
/* --------------------------------------------------------- */
#include <string.h>

char *
nstrcpy (char *dest, char *source, int nchars)
{
 *dest = '\0';
 return(strncat(dest, source, nchars));
}
