
/*----------------------------------------------------------------
   Does a one time comapre of a pattern and a string.

   Entry Requirements:
      string : The string to compare to the pattern.
      pattern : A string which contains the pattern specications.
      single : The character in 'pattern' which identifies a single
               character match.
      multiple : The character in 'pattern' which identifies a mulitple
               character match.
      escape : The character in 'pattern' which is used to escape the
               meaning of the following character.

   Return Value:
      1 : If pattern and string match.
      0 : If they do not or unable to perform compare.

   Development History:
      Begun: 03/05/92 - Todd King

   Version:
      %W%      (UCLA/IGPP)    %G%
------------------------------------------------------------------*/
#include "pattern.h"

int 
pattern_compare (char string[], char pattern[], int single, int multiple, int escape)
{
   PATTERN *p;
   int r;

   p = pattern_parse(pattern, single, multiple, escape);
   if(p == NULL) { return(0); }

   r = pattern_match(string, p);
   pattern_free(p);

   return(r);
}
