/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/

/*---------------------------------------------------------------
  BufShiftOut(int num_rec)
    Shift num_rec number of records out of the buffer list and into
    the output flow.
 
  Return:
    TRUE always.
 
  Entry Requirements:
    itn num_rec.

  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
  ---------------------------------------------------------------*/

#include "pipec.h"

int 
BufShiftOut (int num_rec)
{
 
 RECPTR *hold_current;
 RECPTR *hodl_lastreq;
 int    reset_current;
 int    reset_lastreq;
 int    index, nunrecs = num_rec;
 extern BUFFER_HEAD  _Rbuffer;

 if (nunrecs > _Rbuffer.nrecs) nunrecs = _Rbuffer.nrecs;

for (index = 0; index < nunrecs; index++) {
   BufUseRec(1);
   wdata();
   BufDeleteRec(1);
 }  /* end of for */

 return(TRUE);
}  /* end of buf_shift_out() */

 

