/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/

/*---------------------------------------------------------------
  BufStoreRec()-
    Stores record in the buffer list, current active record.
 
  Return:
    FLASE: on error.
    TRUE:
 
  Entry Requirements:
    None.
 
  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
  ---------------------------------------------------------------*/

#include <malloc.h>
#include "pipec.h"

int 
BufStoreRec (void)
{
  extern BUFFER_HEAD  _Rbuffer;
  extern char         *Rbuffer;
  RECPTR              *oldlast, *oldlastnext;

  if (_Rbuffer.num_fixed == TRUE) {
    _Rbuffer.last == _Rbuffer.last->next;
    _Rbuffer.nrecs++;
    if (_Rbuffer.last == _Rbuffer.end)   _Rbuffer.last  = _Rbuffer.end->next;
    if (_Rbuffer.last == _Rbuffer.first) _Rbuffer.nrecs--;
    if (_Rbuffer.last == _Rbuffer.first) _Rbuffer.first = _Rbuffer.first->next;

  } else {
    oldlast     = _Rbuffer.last;
    oldlastnext = _Rbuffer.last->next;
    
    if ((_Rbuffer.last->next = (RECPTR *) BufMalloc(sizeof(RECPTR))) == NULL) 
      {_Rbuffer.last->next = oldlastnext; return(FALSE);}
    _Rbuffer.last = _Rbuffer.last->next;
    _Rbuffer.last->next     = _Rbuffer.end;
    _Rbuffer.last->vmrecnum = BufRealMem;

    if ((_Rbuffer.last->data = BufMalloc(_Rbuffer.recl)) == NULL) {
      free(_Rbuffer.last);
      _Rbuffer.last       = oldlast; 
      _Rbuffer.last->next = oldlastnext;
      return(FALSE);
    } /* end of if */

    if (_Rbuffer.first == _Rbuffer.end) _Rbuffer.first = _Rbuffer.first->next;
    _Rbuffer.nbufs++;
    _Rbuffer.nrecs++;
  }  /* end of if-else */

  memcpy(_Rbuffer.last->data, Rbuffer, _Rbuffer.recl);
  return(TRUE);
}  /* end of buf_store_rec() */




