/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/

/*---------------------------------------------------------------
  BufUnuseRec() -
    Return the state of the currect buffer pointer to the state
    before the last BufUseRec() call.  This lets you jump back
    and front from record.
    WARNING: some function also call BufUseRec().  Be careful
    will using it.
 
  Return:
    TRUE: always.
     
  Entry Requirements:
    NOne.
 
  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
  ---------------------------------------------------------------*/

#include "pipec.h"

int 
BufUnuseRec (void)
{
  RECPTR *tmpptr;
  extern BUFFER_HEAD  _Rbuffer;
  extern char         *Rbuffer;
  int                 itemp;

  if (_Rbuffer.last_request == _Rbuffer.end) return(FALSE);
  tmpptr                = _Rbuffer.last_request;
  _Rbuffer.last_request = _Rbuffer.current;
  _Rbuffer.current      = tmpptr;

  itemp                 = _Rbuffer.num_last_req;
  _Rbuffer.num_last_req = _Rbuffer.num_current;
  _Rbuffer.num_current  = itemp;

  Rbuffer = BufMapData(_Rbuffer.current);

  return(TRUE);
}  /* end of BufUnuseRec() */

