/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/

/*---------------------------------------------------------------
  GetColStr(int bufnum, char colname[]) -
    gets the value of the column "colname" of a record in the buffer
    list or active record given by "buffnum".  
    
  Return:
     NULL:  on error on error,
     else:  a string with the text value of the record.
        
  Entry Requirements:
    int bufnum: number of the buffer in the list, or
                0 for the active record.
 
  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
  ---------------------------------------------------------------*/

#include "pipec.h"

char *
GetColStr (int bufnum, char colname[])
{
  double             buffgetcolval();

  extern BUFFER_HEAD _Rbuffer;
  extern char        Sbuffer[];
  extern DESC        Desc[];
  int                cnum, i;
  char               Tbuffer[MAXLENGTH];
  RECPTR             *ptr;
  char               *data;


  Sbuffer[0]='\0';
  if (bufnum < 0)              return(NULL);
  if (bufnum > _Rbuffer.nrecs) return(NULL);

  cnum = colnum(colname);
  cnum--;
  if(cnum < 0)               return(NULL);    /* Not found */

  if (bufnum == 0)    
    data = _Rbuffer.working->data;
  else {
    ptr  = BufGetRecPtrOf(bufnum);
    data = BufMapData(ptr);
  }  /* end of if-else */
  
  for(i=0;i<Desc[cnum].width;i++) Tbuffer[i]=data[Desc[cnum].start+i];
  Tbuffer[i]='\0';

  switch(Desc[cnum].type) {
  case 'I':
    sprintf(Sbuffer, "%d", (* (int *)Tbuffer));
    break;
  case 'R':
    sprintf(Sbuffer, "%f", (* (float *)Tbuffer));
    break;
  case 'D':
    sprintf(Sbuffer, "%lf", (* (double *)Tbuffer));
    break;
  case 'A':
    strncpy(Sbuffer, Tbuffer, Desc[cnum].width);
    Sbuffer[Desc[cnum].width] = '\0';
    break;
  case 'T':
    sprintf(Sbuffer, "%lf", (* (double *)Tbuffer)); 
    break;
  }  /* end of switch */

  return(Sbuffer);
}  /* end of GetColStr() */


