/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/
 
/*--_SETCOLVAL ----------------------
 Sets a column to the given value.
 returns -1 if the value could not
 set for whatever reason.
 Will set a column only if it is
 an output column (if it hasn't
 been removed).  This function is
 named _setcolval because of the
 preprocessor macro definition:
 #define setcolval(a,b)
           _setcolval(a,(double) b)

 Entry Requirements:
   the short column name followed
   by the value to set the column
   to.

 Development History:
   Begun : 12/21/92 - Gilbert Hyatt  
------------------------------------*/

#include "pipec.h"

int 
_SetColVal (int bufnum, char *colname, double value)
{
  extern BUFFER_HEAD _Rbuffer;
  RECPTR             *ptr;
  char               *data;
 

  if (bufnum < 0)              return(infinity());
  if (bufnum > _Rbuffer.nrecs) return(infinity());

  if (bufnum == 0)   
    data = _Rbuffer.working->data;
  else {
    ptr  = BufGetRecPtrOf(bufnum);
    data = BufMapData(ptr);
  }  /* end of if-else */

  return(_buffsetcolval(data, colname, value));
}  /* end of GetColStr() */
