/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- COLTYPE ---------------------------
 Returns the variable type associated
 with the given column name. Returns
 a space if the column name is not
 found. Always returns the first
 of the column name if one is found.

 Entry requirements:
  COLNAME: The short column name to
           determine its index.

 Developemnt History:
    Begun: 2/28/86 - Todd King
       Under GH06 support.
  Edited:04/14/94 - Gilbert Hyatt
    Now uses pipec.h as entry point
    into the library.
--------------------------------------*/

#include "pipec.h"

int 
coltype (char colname[])
{
  int cindex;
  char type;

  extern DESC Desc[];

  cindex=colnum(colname);
  cindex--;   
  if (cindex < 0) return(' ');
  type=Desc[cindex].type;
  return(type);
}

