/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- COLWIDTH ----------------------------
 Returns the width associated with the
 given column index. Returns a -1 if
 index is invalid, otherwise returns
 the width associated with the column.
 The index count starts at 1.

 Entry Requirements:
    COLNAME: The short column name for
             the desired information.

 Development History:
   Begun: 3/17/86 - Todd King
          Under GH06 support.
  Edited:04/14/94 - Gilbert Hyatt
    Now uses pipec.h as entry point
    into the library.
----------------------------------------*/

#include <stdio.h>
#include "pipec.h"

int 
colwidth (char colname[])
{
  extern DESC Desc[];
  extern int Ndesc;

  int cindex; 
  cindex=colnum(colname); 
  cindex--;

  if(cindex < 0) return(-1);  /* No can do */
  return(Desc[cindex].width);
}
