/*---------------------------------------------------------------*/
/*   Copyright (c) 1990 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/

/*-- dfs_fill_buffer ----------------------------------------------
   Reads in records from the data flow and fills a record
   buffer. If an end of data is encountered before the
   buffer is filled then 0 (FALSE) is returned, otherwise 
   a 1 (TRUE) is returned.

   Entry Requirements:
       buffer: A pointer to a record buffer (created by make_buffer())

   Development History:
      Begun: 10/19/90 - Todd King 
      Edited:04/14/94 - Gilbert Hyatt 
        Now uses pipec.h as entry point into the library.

-----------------------------------------------------------------*/

#include "pipec.h"

int 
dfs_fill_buffer (DFS_RECBUFF *buffer)
{
   int i;

   if(buffer == NULL) return(FALSE);

   dfs_set_buffer_record(buffer, dfs_buffer_nextrec(buffer));
   for(i = buffer->nrecs; i < buffer->max_recs; i++) {
     if(rdata() <= 0) return(FALSE);
     dfs_store_buffer_record(buffer);
   }

   return(TRUE);
}

