/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- FLAGCLEAR -------------------------------
 Clears the given flag (sets to 0) for the
 given column in the descriptor structures.
 Always returns 1.

 Entry requirements:
   FLAG: Flag or composite flag to clear.
   COL:  Index of column descriptor to
         change.

 NOTE:  the column index passed to flagset
        should use zero-indexing.

 Development History
   Begun: 8/10/86 - Marco Zagha
         Under GG44 support.
  Edited:04/14/94 - Gilbert Hyatt
    Now uses pipec.h as entry point
    into the library.
--------------------------------------------*/

#include "pipec.h"

int 
flagclear (unsigned int flag, int col)
{
   extern DESC Desc[];

/* Performs a bitwise AND of Desc[col].flags with the one's */
/* complement of flag.                                      */
/* In other words, everywhere a bit in flag is a 1,         */
/* make the corresponding bit in Desc[col].flags a 0;       */
/* everywhere a bit in flag is a 0, leave the corresponding */
/* bit in Desc[col].flags as it was. */

   Desc[col].flags &= (~flag);
   return (1);
}
