/*---------------------------------------------------------------*/
/*   Copyright (c) 1990 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/

/*-- dfs_flush_buffer ---------------------------------------------------
   Clears the contents of a record buffer. You can optionally 
   have the contents written to the data flow as the clearing
   operation is done.

   Entry Requirements:
       buffer: A pointer to a record buffer (created by make_buffer())
       write_out: A flag indicating whether or not to write the
	   shifted records out to the data flow. If TRUE the records
	   are written to the data flow, otherwise the records are not.

   Development History:
      Begun: 10/19/90 - Todd King
      Edited:04/14/94 - Gilbert Hyatt 
        Now uses pipec.h as entry point into the library.
 ------------------------------------------------------------------*/

#include "pipec.h"

int 
dfs_flush_buffer (DFS_RECBUFF *buffer, int write_out)
{
   int i;

   if(buffer == NULL) return(FALSE);

   if(write_out) {
      for(i = 0; i < buffer->nrecs; i++) {
	 dfs_use_buffer_record(buffer, i);
	 wdata();
      }
   }

   buffer->cur_rec = 0;
   buffer->first_rec = 0;
   buffer->nrecs = 0;
}

