/*---------------------------------------------------------------*/
/*   Copyright (c) 1990 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/

/*-- dfs_free_buffer --------------------------------------------------
   Frees all memory allocated on behalf of the creation of a buffer.
   Once this call is made a buffer is no longer useable.

   Entry Requirements:
       buffer: A pointer to a record buffer (created by make_buffer())

   Development History:
      Begun: 10/19/90 - Todd King
      Edited:04/14/94 - Gilbert Hyatt 
        Now uses pipec.h as entry point into the library.
 -----------------------------------------------------------------------*/

#include "pipec.h"

int 
dfs_free_buffer (DFS_RECBUFF *buffer)
{
   if(buffer == NULL) return(FALSE);

   free(buffer->raw);
   free(buffer);
}

