/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- INITPIPE --------------------------------------------------------------

 This function initializes the variables needed to read command line
 arguments.  It should be called once, before the first call to
 getcmdlineopt.


 RETURN VALUES:
	Always returns 1.

	Development History:
		Begun:  7/24/86 - Marco Zagha
                  Under GG44 support.

              Edited: 03/18/94 - Gilbert Hyatt
                  Now Extracts _datain, _dataout, _errlog, and _stdstd
                  options from the command line, and sets these options to
                  NULL.  Then set datain, dataout, errlog if needed.
              Edited:04/14/94 - Gilbert Hyatt
                Now uses pipec.h as entry point into the library.

--------------------------------------------------------------------------*/

#include <stdio.h>
#include <sys/types.h>  /* for open() */
#include <sys/stat.h>   /* for open() */
#include <fcntl.h>      /* for open() */
#include "pipec.h"
#define  MATCHS         "_DATAIN _DATAOUT _ERRLOG _STDSTD "

extern char xxFittingName[];	/* Defined in FittingName.c */

static enum {DATAIN =0, DATAOUT, ERRLOG, STDSTD};

static int 
ChangeFD (char *argv[], int *file, char *fileName, int match)
{
  int fd;

  if(isdigit(*fileName))  *file = atoi(fileName);
  else {
    if(match == DATAIN) fd = open(fileName, O_RDONLY);
    else               fd = open(fileName, O_WRONLY|O_CREAT|O_TRUNC, 00664);
    if(fd == -1) {
      getcmdexit(argv, match, fileName); 
      perror(fileName);
    } else *file = fd;
  }
}


/*-- GETCMDEXIT ------------------------------------------------------------
 Subroutine to print an error message with a filler and exit the program.
 The fitting name is extracted from argv[0].  The path is stripped off the
 fitting name.


 ENTRY REQUIREMENTS:
	argv:    the command line arguments from the program.
	errnum:  an integer code for an error message.
	filler:  a string which is part of the error message.

	Fill in:
		a) the correct value for NumErrors
		b) the individual error messages (put @ everywhere filler
                 should appear and end all fatal errors with '!')

	Development History:
		Begun:  7/16/86 - Marco Zagha

--------------------------------------------------------------------------*/

static int 
getcmdexit (char *argv[], int err_num, char filler[])
{
#define NumErrors 5

  int start;
  char fitting[50];
  char tempstr[150];
  char *error[NumErrors];

  strcpy(tempstr, argv[0]);

  for (start = strlen(tempstr)-1; start > 0 && tempstr[start] != '/'; start--)
    ; /* Find the last slash in tempstr */
  if (tempstr[start] == '/') start = start + 1;
  strcpy(fitting, &tempstr[start]);

  error[DATAIN]  = "Error: Can not open input  file '@'!";
  error[DATAOUT] = "Error: Can not open output file '@'!";
  error[ERRLOG]  = "Error: Can not open errlog file '@'!";

  fillerrexit(err_num, NumErrors, fitting, error, filler);
#undef NumErrors
}

int 
_InitPipe (int argc, char *argv[])
{
  char  buffer[1000];    /* randomly large */
  char  *part[2];
  int   match, index;
  char  *possible[5];
  char  kw_list[50];

  /* strings set for cleanliness */
  strcpy(pdbprefix,     ""); 
  strcpy(pdbOptName,    "");
  strcpy(xxFittingName, "");

  /* Chnage datapipes: datain, dataout, errlog */
  strcpy(kw_list, MATCHS); 
  parse( kw_list, possible, " ", 5); 

  for(index =1; index < argc; index++) {
    if(argv[index] == NULL) continue; /* In case run more than once */
    strcpy(buffer, argv[index]);
    part[0]="";
    part[1]="";
    parse(buffer, part, "=", 2);
    trimspc(part[0]);
    trimspc(part[1]);
    unquote2(part[1]);
    scaseup(part[0]);  /* Upper case standard for keywords */
    match = kw_match(part[0], possible);
    
    /* NOTE: chaining command files is not allowed */
    switch(match) {
    case DATAIN:
      ChangeFD(argv, &datain,  part[1], match);
      argv[index] = NULL;
      break;
    case DATAOUT:
      ChangeFD(argv, &dataout, part[1], match);
      argv[index] = NULL;
      break;
    case ERRLOG:
      ChangeFD(argv, &errlog,  part[1], match);
      argv[index] = NULL;
      break;
    case STDSTD:
      datain  =0; dataout =1; errlog  =2;
      argv[index] = NULL;
      break;
    default:
      break;
    }  /* end of switch */
  }  /* end of for */

  return(1);
}

