/*---------------------------------------------------------------*/
/*   Copyright (c) 1990 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/

/*-- dfs_nrecs_buffer --------------------------------------------------
   Returns the number of records currently in the record buffer.
   An invalid buffer pointer returns -1.

   Entry Requirements:
       buffer: A pointer to a record buffer (created by make_buffer())

   Development History:
      Begun: 10/19/90 - Todd King
      Edited:04/14/94 - Gilbert Hyatt
        Now uses pipec.h as entry point into the library.
-----------------------------------------------------------------------*/

#include "pipec.h"

int 
dfs_nrecs_buffer (DFS_RECBUFF *buffer)
{
   if(buffer == NULL) return(-1);
   return(buffer->nrecs);
}

