/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- PASSTHRU -----------------------------------------------------
 Pass through all data in an the data pipe.  It is up to the
 calling program to actually send the ending signals down the
 pipe.  The information is  passed through in an efficient manner
 by reading and writing blocks of 1K bytes each. Short blocks
 are handled properly.

 Returns:
   Always 1.

  Entry Requirements:
    NONE.

  Developement History:
    Begun: 04/17/87 - Todd King
                  Under GH06 support.
    Update: 6/8/87 - Marco Zagha
                   No descriptor pipe anymore!
                  Under GG44 support.
    Update: 7/20/88 - Todd King
          Added checks to see if there is data in any of the
          buffers.
          Under GH06 support.
    Edited:04/14/94 - Gilbert Hyatt
      Now uses pipec.h as entry point into the library.
-----------------------------------------------------------------*/

#include "pipec.h"

#define BUFF_SIZE 1024

int 
passthru (void)
{
  extern BLOCK Out;
  extern BLOCK In;

  char buff[BUFF_SIZE];
  int nbytes;

  pflush();	/* Clear output buffer */
  if(In.guage > 0 && In.guage != In.offset) /* Something in input buffer */
  {
    write(dataout, In.block + In.offset, In.guage - In.offset);
  }
  while((nbytes = read(datain, buff, BUFF_SIZE)) > 0)
     write(dataout, buff, nbytes);
  return(1);
}
