/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- PUTREC --------------------------------------
 Puts the current output record into an output
 record block. If the block is full it then
 sends the block out the data pipe.

  Entry Requirements:
    NONE

  Developement History:
    Begun: 11/4/86  - Todd King
            Under GH06 support.
    Update: 1/7/87 - Marco Zagha
            Under GG44 support.
    Update: 01/26/94 - Gilbert Hyatt
            Changed bcopy() to memmove()
    Edited:04/14/94 - Gilbert Hyatt
      Now uses pipec.h as entry point
      into the library.
------------------------------------------------*/

#include "pipec.h"

int 
putrec (void)
{
  extern char Outbuffer[];
  extern BLOCK Out;
  extern BUFFER Outrec;

  int ret;

  if (Outrec.length == 0) return (-1);
  if(Out.full == 0) Out.full=BLKSIZE-BLKSIZE%Outrec.length;
  if(Out.guage + Outrec.length > Out.full)		/* Block full */
  {
    ret=write(dataout, Out.block, Out.guage);
    if(ret <= 0) return(ret);	/* Trouble in paradise */
    Out.guage=0;
  }
  memcpy(Out.block+Out.guage, Outrec.buffer, Outrec.length);
  Out.guage+=Outrec.length;
  return(Outrec.length);
}

