/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- RMVDESC ----------------------------
 Removes a given descriptor definition
 from the database. Once removed any
 data in the input stream associated
 with the descriptor in NOT accessable

 Entry Requirements:
  COLNAME: The short column name
           associated with the
           descriptor to remove.

 Developement History:
    Begun:  2/21/86 - Todd King
            Under GH06 support.
    Update: 8/7/86  - Marco Zagha
            Under GG44 support.
    Update: 6/9/87  - Marco Zagha
      (Check to make sure descriptors
       have not been written out)
            Under GG44 support.
    Edited:04/14/94 - Gilbert Hyatt
      Now uses pipec.h as entry point
      into the library.
---------------------------------------*/

#include "pipec.h"

int 
rmvdesc (char colname[])
{
  int descno;

  extern int Descriptors_written;
  extern int Ndesc;
  extern DESC Desc[];

  if (Descriptors_written) return (-1);  /* Too late now!! */
  descno=excolnum(colname); 			/* Get number */
  descno--;
  if(descno<0) return(-1);      /* Nothing there */

  Desc[descno].flags=Desc[descno].flags^OUTPUT; /* Turn output off */
  return(0);
}

