/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- SCOLNAME --------------------------------
 Returns the short caolumn name for the
 column index given. Returns a null
 pointer if the index is not a valid
 index, otherwise returns a pointer to
 a string containing the short column
 name. This string is a temporary string
 therfore it may not still exist after
 any subsequent calls. Hence copying it
 into permant strorage is recommended.
 The index count starts at 1.


 Mapping for return values for char funtions

 Function   Chars used      Return address
 --------   ----------      --------------
 scolname   0-8    9 chars      &Sbuffer[0]
 lcolname   9-41  33 chars      &Sbuffer[9]
 colunits   42-58 17 chars      &Sbuffer[42]
 uniqname   59-67  9 chars      &Sbuffer[59]

 Entry Requirements:
    CINDEX: The index number for the
            desired information.

 History:
   Begun: 3/14/86 - Todd King
            Under GH06 support.
   Update: 4/28/87 - Marco Zagha
            Under GG44 support.
   Edited:04/14/94 - Gilbert Hyatt
     Now uses pipec.h as entry point
     into the library.
---------------------------------------------*/

#include <stdio.h>
#include "pipec.h"

char *
scolname (int cindex)
{
  extern DESC Desc[];
  extern int Ndesc;
  extern char Sbuffer[];

  Sbuffer[0]='\0';
  if(cindex > Ndesc || cindex < 1) return(Sbuffer);  /* No can do */
  cindex--;
  strcpy(Sbuffer,Desc[cindex].shortcol);
  return(Sbuffer);
}
