/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- SETCOLFLAG ------------------------
 Sets the value for the given column
 to a flag value defined in the
 includes or '?' for strings.
 Returns the result of setcolval or
 -1 if an error occured.

 Entry Requirements:
   The short column name to set to a
   flag.

 Developement History:
   Begun:  7/28/86 - Marco Zagha
            Under GG44 support.
   Edited:04/14/94 - Gilbert Hyatt
     Now uses pipec.h as entry point
     into the library.
------------------------------------*/

#include "pipec.h"

int 
setcolflag (char colname[])
{
  extern DESC Desc[];

  int descno, retval;

  descno = colnum(colname) - 1;
  if (descno < 0) return (-1);    		/* Not valid column name */

  switch(Desc[descno].type)
  {
    case 'I':
	      retval = setcolval(colname, FLAGINT);
	      break;
    case 'R':
	      retval = setcolval(colname, FLAGREAL);
	      break;
    case 'T':
    case 'D':
	      retval = setcolval(colname, FLAGDOUBLE);
	      break;
    case 'A':
	      retval = setcolstr(colname, "?");
	      break;
  }
  return (retval);
}
