
/*---------------------------------------------------------------*/
/*   Copyright (c) 1990 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/

/*-- dfs_store_buffer_record ---------------------------------------
   Places a copy of the current DFS working record in the
   based record buffer area and advances to the next record in
   the buffer. Returns 1 (TRUE) if the operation was successful,
   0 (FALSE) otherwise. Failure can occur only when the addition 
   of a record would exceed the capacity of the record buffer or
   the passed record buffer is invalid.

   Entry Requirements:
       buffer: A pointer to a record buffer (created by make_buffer())

   Development History:
      Begun: 10/19/90 - Todd King
    Edited:04/14/94 - Gilbert Hyatt
      Now uses pipec.h as entry point into the library.
-----------------------------------------------------------------*/

#include "pipec.h"

int 
dfs_store_buffer_record (DFS_RECBUFF *buffer)
{
   int i;

   if(buffer == NULL) return(FALSE);

   if(buffer->nrecs == buffer->max_recs) return(FALSE);

   dfs_save_buffer_record(buffer);

  /* Now advance the current record pointer */
   buffer->nrecs++;
   buffer->cur_rec = (buffer->first_rec + buffer->nrecs) % buffer->max_recs;

   return(TRUE);
}

