/*----------------------------------------------------------------
   Definitions for use with the pattern matching functions.

   Development History:
      Begun: 03/02/92 - Todd King

   Version:
      @(#)pattern.h	1.4    (UCLA/IGPP)   5/9/94
------------------------------------------------------------------*/
#ifndef pattern_h
#define pattern_h	1

#include <stddef.h>	/* For NULL */

/* Type definitions */

typedef struct PATTERN {
   int type;			/* Type of this token */
   char *text;			/* Text to match (FIXED token only) */
   unsigned int text_len;	/* Length of text */
   struct PATTERN *next;	/* Next token in list */
} PATTERN;

typedef struct PATTERN_PART {
   char	*text;	
   struct PATTERN_PART	*next;	/* Next item in list */
} PATTERN_PART;

/* PAttern token types */

#define PATTERN_TYPE_SINGLE_CHAR	1
#define PATTERN_TYPE_MULTIPLE_CHAR	2
#define PATTERN_TYPE_FIXED		3

/* Function prototypes */

PATTERN *pattern_parse();
PATTERN *pattern_make();
PATTERN *pattern_fixed();
void pattern_dump();
void pattern_free();
PATTERN_PART *pattern_part();
PATTERN_PART *pattern_part_push();
PATTERN_PART *pattern_part_get();
char *pattern_replace();
int pattern_match();


#endif /* pattern_h */

