/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffclose_select -----------------------------------------
  Closes selected components of a flatfile.

  Entry Requirements:
    ffptr: A flat file pointer (as returned from ffopen() )
    compon: A composite flag (see ffopen_select() for details).

  Return Value:
    FF_SUCCESS if the selected portions of hte flatfile
               are closed.
    FF_FAILURE if the flatfile pointer is invalid.

  Development History:
     Begun: 9/05/89 - Todd King
-------------------------------------------------------------*/
#include "ffio.h"

int 
ffclose_select (FLATFILE *ffptr, unsigned int compon)
{
  int updated = FALSE;

  if(ffptr == NULL) return(FF_FAILURE);

  if( (compon & FF_DES) &&
      (ffptr->open_status & FF_DES) ) { 
    fclose(ffptr->desc);
    ffptr->open_status -= FF_DES;
  }
  if( (compon & FF_DAT) &&
      (ffptr->open_status & FF_DAT) ) {
    ffupdate(ffptr);
    fclose(ffptr->data);
    ffptr->open_status -= FF_DAT;
    updated = TRUE;
  }
  if( (compon & FF_ABS) &&
      (ffptr->open_status & FF_ABS) ) {
    fclose(ffptr->abs);
    ffptr->open_status -= FF_ABS;
  }
  if( (compon & FF_HED) &&
      (ffptr->open_status & FF_HED) ) { 
    if(!updated) ffupdate(ffptr);
    fclose(ffptr->hed);
    ffptr->open_status -= FF_HED;
  }

  if(ffptr->style == FF_STYLE_VIRTUAL) {
     fclose(ffptr->vinfo.fptr);
  }

  if(compon == FF_ALL) {	/* also free allocated memory */
    free(ffptr->descdb);
    free(ffptr->rec_buff);
    free(ffptr);
    if(ffptr->bindlist != NULL) { free(ffptr->bindlist); }
    ffptr = NULL;
  }
  return(FF_SUCCESS);
}

