/*---------------------------------------------------------------*/
/*   Copyright (c) 1991 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%	(UCLA/IGPP)	%G%
*/
/*-- ffcol_sname.c -------------------------------------------------------
  Returns the short column name for the given field. 

  Entry Requirements:
    ffptr: A pointer to a flatfile.
    idx: The index of the column to bind to.

  Return Value:
   NULL: If the field index or the flatfile pointer is incorrect.
   otherwise: the short name of the field is returned.

  Development History:
    Begun: 04/14/93 - Todd King     
-----------------------------------------------------------------*/
#include "ffio.h"
#include <string.h>

char *
ffcol_sname (FLATFILE *ffptr, unsigned int idx)
{
   FF_FULL_DESC *dptr;

   if(ffptr == NULL) return(NULL);

   dptr = ffget_desc(ffptr, idx);
   if(dptr == NULL) return(NULL);

   return(strdup(dptr->shortname));
}
