/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G%
*/
/*-- ffcompare -------------------------------------------------
  Compare the columns in a FLATFILE to the columns in the data
  flow, to see if they are the same.
  The same meaning the same number of columns, 
  the same column names, the same column type, and width.  Their
  long names, abstact, and actual data can differ.
 
   Entry Requirements:
    ffptr:    A flat file pointer (as returned from ffopen() )
 
  Return Value:
     FF_SUCCESS: If same. 
     FF_FAILURE: If different. 
 
  Development History:
    Begun: 10/11/93 - Gilbert Hyatt
-------------------------------------------------------------*/
#include "ffio.h"
#include "funcdefc.h"
#include <memory.h>
#include <string.h>
 

int 
ffcomparedf (FLATFILE *ffptr)
{
  int              index,    good, i;
  FF_FULL_DESC     *ffdesc;
  extern       int Ndesc, Recl,Next_start;
  char         sname[FF_SNAME+1];

  if(ffptr == NULL)               return(FF_FAILURE);
  if(ffptr->ncols  != Ndesc)      return(FF_FAILURE);
  if(ffptr->reclen != Next_start) return(FF_FAILURE);
fprintf(stderr, "Passed first tests \n");

  good = TRUE;
  for(index =0; index < Ndesc; index++) {
    ffdesc = ffget_desc(ffptr, index);

    strncpy(sname, scolname(index+1), strlen(scolname(index+1)));
    for(i=0; i < (int) strlen(sname); i++) if(sname[i] == ' ') sname[i] = '\0';

    if(strcmp(ffdesc->shortname, sname) !=0) good = FALSE;
    if(ffdesc->type  !=  coltype(sname))     good = FALSE;
    if(ffdesc->width != colwidth(sname))     good = FALSE;
  }

  if(good == TRUE) return(FF_SUCCESS);
  else             return(FF_FAILURE);
}


